/////////////////////////////////////////////////////////////////////////////////////////
//
// LCD Library for Freescale DEMO9S08GW64
//
/////////////////////////////////////////////////////////////////////////////////////////
#include "lcd_config.h"

/////////////////////////////////////////////////////////////////////////////////////////
// Defines
/////////////////////////////////////////////////////////////////////////////////////////
#define LCD_NO_OF_BACK_PLANES  8           //1-8

#define LCD_CLOCK LCD_CLOCK_EXT            // LCD_CLOCK_EXT: OSCOUT (external clock reference) as the LCD clock source
                                           // LCD_CLOCK_ALT: alternate clock as the LCD clock source

#define LCD_VSUPPLY LCD_VLL3_FROM_VDD       //LCD_VLL2_FROM_VDD  :  drives VLL2 internally from VDD
                                            //LCD_VLL3_FROM_VDD  :  drives VLL3 internally from VDD
                                            //LCD_VLL1_FROM_VLCD :  drives VLL1 internally from VLCD
                                            //LCD_VLL3_FROM_EXT  :  drives VLL3 externally or V(IREG) 

#define LCD_CLOCK_PRESCALER  0   

#define LCD_CHARGE_PUMP_SELECT LCD_CHARGE_PUMP_ENABLE   //LCD_CHARGE_PUMP_ENABLE: charge pump is enabled
                                                        //LCD_CHARGE_PUMP_DISABLE: resistor network enabled

#define LCD_LOAD_ADJUST  3

#define LCD_CLOCK_EXT 0
#define LCD_CLOCK_ALT 1                               

#define LCD_CHARGE_PUMP_ENABLE      1      //charge pump is enabled
#define LCD_CHARGE_PUMP_DISABLE     0      //resistor network enabled

#define LCD_VLL2_FROM_VDD           0      //drives VLL2 internally from VDD
#define LCD_VLL3_FROM_VDD           1      //drives VLL3 internally from VDD
#define LCD_VLL1_FROM_VLCD          2      //drives VLL1 internally from VLCD
#define LCD_VLL3_FROM_EXT           3      //drives VLL3 externally or V(IREG) 


#define LCD_CHAR_SPACE          0       // ' ' (Space)
#define LCD_CHAR_QUOTMARK       1       // '"' (Quotation Mark)
#define LCD_CHAR_APOSTROPHE     2       // ''' (Apostrophe)
#define LCD_CHAR_LPAREN         3       // '(' (Left Parenthesis)
#define LCD_CHAR_RPAREN         4       // ')' (Right Parenthesis)
#define LCD_CHAR_ASTERISK       5       // '*' (Asterisk)
#define LCD_CHAR_PLUS           6       // '+' (Plus Sign)
#define LCD_CHAR_COMMA          7       // ',' (Comma)
#define LCD_CHAR_MINUS          8       // '-' (Minus Sign)
#define LCD_CHAR_PERIOD         9       // '.' (Period)
#define LCD_CHAR_SLASH          10      // '/' (Slash)
#define LCD_CHAR_0              11      // '0'
#define LCD_CHAR_1              12      // '1'
#define LCD_CHAR_2              13      // '2'
#define LCD_CHAR_3              14      // '3'
#define LCD_CHAR_4              15      // '4'
#define LCD_CHAR_5              16      // '5'
#define LCD_CHAR_6              17      // '6'
#define LCD_CHAR_7              18      // '7'
#define LCD_CHAR_8              19      // '8'
#define LCD_CHAR_9              20      // '9'
#define LCD_CHAR_SEMICOLON      21      // ':' (Semicolon)
#define LCD_CHAR_EQUAL          22      // '=' (Equal Sign)
#define LCD_CHAR_A              23      // 'A'
#define LCD_CHAR_B              24      // 'B'
#define LCD_CHAR_C              25      // 'C'
#define LCD_CHAR_D              26      // 'D'
#define LCD_CHAR_E              27      // 'E'
#define LCD_CHAR_F              28      // 'F'
#define LCD_CHAR_G              29      // 'G'
#define LCD_CHAR_H              30      // 'H'
#define LCD_CHAR_I              31      // 'I'
#define LCD_CHAR_J              32      // 'J'
#define LCD_CHAR_K              33      // 'K'
#define LCD_CHAR_L              34      // 'L'
#define LCD_CHAR_M              35      // 'M'
#define LCD_CHAR_N              36      // 'N'
#define LCD_CHAR_O              37      // 'O'
#define LCD_CHAR_P              38      // 'P'
#define LCD_CHAR_Q              39      // 'Q'
#define LCD_CHAR_R              40      // 'R'
#define LCD_CHAR_S              41      // 'S'
#define LCD_CHAR_T              42      // 'T'
#define LCD_CHAR_U              43      // 'U'
#define LCD_CHAR_V              44      // 'V'
#define LCD_CHAR_W              45      // 'W'
#define LCD_CHAR_X              46      // 'X'
#define LCD_CHAR_Y              47      // 'Y'
#define LCD_CHAR_Z              48      // 'Z'
#define LCD_CHAR_LBRACKET       49      // '[' (Left Bracket)
#define LCD_CHAR_RBRACKET       50      // ']' (Right Bracket)
#define LCD_CHAR_BACKSLASH      51      // '\' (Backslash)
#define LCD_CHAR_EXPONENT       52
#define LCD_CHAR_UNDERLINE      53      // '_' (Underline)
#define LCD_CHAR_VERTBAR        54      // '|' (Vertical Bar)
#define LCD_CHAR_TEST           55      // All segments on

#define LCD_SEG_NONE            0x00    //no segment is selected


#define LCD_SEG_J                   0x01
#define LCD_SEG_K                   0x02
#define LCD_SEG_B                   0x04
#define LCD_SEG_C                   0x08
#define LCD_SEG_L                   0x10
#define LCD_SEG_M                   0x20
#define LCD_SEG_D                   0x40
#define LCD_SEG_SP1                 0x80

#define LCD_SEG_A                   0x01
#define LCD_SEG_H                   0x02
#define LCD_SEG_F                   0x04
#define LCD_SEG_G                   0x08
#define LCD_SEG_E                   0x10
#define LCD_SEG_N                   0x20
#define LCD_SEG_SP2                 0x40
#define LCD_SEG_SP3                 0x80

#define LCD_SEG_M5                  0x01
#define LCD_SEG_M4                  0x02
#define LCD_SEG_M6                  0x04
#define LCD_SEG_M3                  0x08
#define LCD_SEG_M7                  0x10
#define LCD_SEG_M2                  0x20
#define LCD_SEG_M1                  0x40
#define LCD_SEG_M8                  0x80

#define MASK_JKBCLMD            (LCD_SEG_J|LCD_SEG_K|LCD_SEG_B|LCD_SEG_C|LCD_SEG_L|LCD_SEG_M|LCD_SEG_D)
#define MASK_AHFGEN             (LCD_SEG_A|LCD_SEG_H|LCD_SEG_F|LCD_SEG_G|LCD_SEG_E|LCD_SEG_N)

#define LCDPIN_JKBCLMD             0
#define LCDPIN_AHFGEN              1

#define LCDPIN_JKBCLMD_OPP         1
#define LCDPIN_AHFGEN_OPP          0

const struct lcd_char_segs {
  unsigned char JKBCLMD;
  unsigned char AHFGEN;
  
};



#define LCDPIN1   LCDWF2      //Pin 1  of LCD glass connected to LCD2
#define LCDPIN2   LCDWF3      //Pin 2  of LCD glass connected to LCD3
#define LCDPIN3   LCDWF4      //Pin 3  of LCD glass connected to LCD4
#define LCDPIN4   LCDWF5      //Pin 4  of LCD glass connected to LCD5
#define LCDPIN5   LCDWF6      //Pin 5  of LCD glass connected to LCD6
#define LCDPIN6   LCDWF7      //Pin 6  of LCD glass connected to LCD7
#define LCDPIN7   LCDWF8      //Pin 7  of LCD glass connected to LCD8
#define LCDPIN8   LCDWF9      //Pin 8  of LCD glass connected to LCD9
#define LCDPIN9   LCDWF18     //Pin 9  of LCD glass connected to LCD18
#define LCDPIN10  LCDWF19     //Pin 10 of LCD glass connected to LCD19
#define LCDPIN11  LCDWF20     //Pin 11 of LCD glass connected to LCD20
#define LCDPIN12  LCDWF21     //Pin 12 of LCD glass connected to LCD21
#define LCDPIN13  LCDWF22     //Pin 13 of LCD glass connected to LCD22
#define LCDPIN14  LCDWF23     //Pin 14 of LCD glass connected to LCD23
#define LCDPIN15  LCDWF24     //Pin 15 of LCD glass connected to LCD24
#define LCDPIN16  LCDWF25     //Pin 16 of LCD glass connected to LCD25
#define LCDPIN17  LCDWF26     //Pin 17 of LCD glass connected to LCD26
#define LCDPIN18  LCDWF27     //Pin 18 of LCD glass connected to LCD27
#define LCDPIN19  LCDWF28     //Pin 19 of LCD glass connected to LCD28
#define LCDPIN20  LCDWF29     //Pin 20 of LCD glass connected to LCD29
#define LCDPIN21  LCDWF30     //Pin 21 of LCD glass connected to LCD30
#define LCDPIN22  LCDWF31     //Pin 22 of LCD glass connected to LCD31
#define LCDPIN23  LCDWF32     //Pin 23 of LCD glass connected to LCD32
#define LCDPIN24  LCDWF33     //Pin 24 of LCD glass connected to LCD33
#define LCDPIN25  LCDWF34     //Pin 25 of LCD glass connected to LCD34
#define LCDPIN26  LCDWF35     //Pin 26 of LCD glass connected to LCD35
#define LCDPIN27  LCDWF36     //Pin 27 of LCD glass connected to LCD36
#define LCDPIN28  LCDWF37     //Pin 28 of LCD glass connected to LCD37
#define LCDPIN29  LCDWF38     //Pin 29 of LCD glass connected to LCD38

/*configures the LCD in 21x8 mode */
/* 21 frontplanes + 8 back planes */
/* LCD pins 2 - 9 are backplanes */
/* LCD pins 18 - 38 are frontplanes*/


#define CONFIG_LCD_MODE  {\
                  LCDPEN0 = 0xFC;     \
                  LCDPEN1 = 0x03;     \
                  LCDPEN2 = 0xFC;     \
                  LCDPEN3 = 0xFF;     \
                  LCDPEN4 = 0x7F;     \
                  LCDPEN5 = 0x00;     \
                  LCDBPEN0 = 0xFC;    \
                  LCDBPEN1 = 0x03;    \
                  LCDBPEN2 = 0x00;    \
                  LCDBPEN3 = 0x00;    \
                  LCDBPEN4 = 0x00;    \
                  LCDBPEN5 = 0x00;    \
                  LCDPIN1 = 0x01;     \
                  LCDPIN2 = 0x02;     \
                  LCDPIN3 = 0x04;     \
                  LCDPIN4 = 0x08;     \
                  LCDPIN5 = 0x10;     \
                  LCDPIN6 = 0x20;     \
                  LCDPIN7 = 0x40;     \
                  LCDPIN8 = 0x80;     \
                }

                  

/* all the segments are OFF by writing 0 to all the frontplane pin registers*/
#define LCD_ALLFP_OFF   {\
                          LCDPIN9 = 0x0;\
                          LCDPIN10 = 0x0;\
                          LCDPIN11 = 0x0;\
                          LCDPIN12 = 0x0;\
                          LCDPIN13 = 0x0;\
                          LCDPIN14 = 0x0;\
                          LCDPIN15 = 0x0;\
                          LCDPIN16 = 0x0;\
                          LCDPIN17 = 0x0;\
                          LCDPIN18 = 0x0;\
                          LCDPIN19 = 0x0;\
                          LCDPIN20 = 0x0;\
                          LCDPIN21 = 0x0;\
                          LCDPIN22 = 0x0;\
                          LCDPIN23 = 0x0;\
                          LCDPIN24 = 0x0;\
                          LCDPIN25 = 0x0;\
                          LCDPIN26 = 0x0;\
                          LCDPIN27 = 0x0;\
                          LCDPIN28 = 0x0;\
                          LCDPIN29 = 0x0;\
                        }


/* all the segments are ON  by writing 0xFF to all the frontplane pin registers*/                        
#define LCD_ALLFP_ON   {\
                          LCDPIN9 = 0xFF;\
                          LCDPIN10 = 0xFF;\
                          LCDPIN11 = 0xFF;\
                          LCDPIN12 = 0xFF;\
                          LCDPIN13 = 0xFF;\
                          LCDPIN14 = 0xFF;\
                          LCDPIN15 = 0xFF;\
                          LCDPIN16 = 0xFF;\
                          LCDPIN17 = 0xFF;\
                          LCDPIN18 = 0xFF;\
                          LCDPIN19 = 0xFF;\
                          LCDPIN20 = 0xFF;\
                          LCDPIN21 = 0xFF;\
                          LCDPIN22 = 0xFF;\
                          LCDPIN23 = 0xFF;\
                          LCDPIN24 = 0xFF;\
                          LCDPIN25 = 0xFF;\
                          LCDPIN26 = 0xFF;\
                          LCDPIN27 = 0xFF;\
                          LCDPIN28 = 0xFF;\
                          LCDPIN29 = 0xFF;\
                         }





#define NUM_DIGITS              9       
#define NUM_CHARS   			      sizeof(lcd_char_table)/sizeof(lcd_char_table[0])


/*contains various symbols that can be shown on the LCD*/
enum symbol { TIME,DT,DATE,FREESCALE,FIRE,TEMP,SNOWFLAKE,
              VOLUME,ALARM,T,P,CONTRAST,MODE,AM,
              PM,OM,KWH,AMPS,VOLTS,PROGRAM,VOL,DTx,COLx,Vx,Tx,Mx};


extern unsigned int qseconds;

/*functions*/
void LCDPutChar(unsigned char character, unsigned char digit);
void LCDWriteSegment(enum symbol s, unsigned char num);
void LCDClearSegment(enum symbol s, unsigned char num);
void LCDClearDigit(unsigned char digit);
void LCDClearSegs(void);
void LCDTest(void);
